/* -LICENSE-START-
** Copyright (c) 2017 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#import "AudioStreamDecoder.h"
#import "BMDStreamingDeckControlNotifier.h"
#import "BMDStreamingDeviceInputNotifier.h"
#import "BMDStreamingDeviceNotifier.h"
#import "OpenGLPreview.h"
#import "VTDecodeSession.h"

#import <Cocoa/Cocoa.h>

class DecodeSessionDelegate;

@interface StreamingPreviewAppDelegate : NSObject <NSApplicationDelegate,
												   BMDStreamingDeviceDelegate,
												   BMDStreamingDeviceInputDelegate,
												   BMDStreamingDeckControlDelegate>
{
    NSWindow*							window;

	IBOutlet NSTextField*				mDeviceNameTextField;
	IBOutlet NSPopUpButton*				mVideoInputModePopup;
	IBOutlet NSPopUpButton*				mVideoEncodingPresetPopup;
	IBOutlet NSButton*					mStartPreviewButton;

	IBOutlet OpenGLPreview*				mPreview;

	DecodeSessionDelegate*				mDecodeDelegate;
	BMDStreamingDeviceNotifier*			mDeviceNotifier;
	BMDStreamingDeviceInputNotifier*	mDeviceInputNotifier;
	BMDStreamingDeckControlNotifier*	mDeckControlNotifier;
	IBMDStreamingDiscovery*				mDiscovery;
	IDeckLink*							mDevice;
	IDeckLinkConfiguration*				mConfiguration;
	IBMDStreamingDeviceInput*			mDeviceInput;
	IDeckLinkDeckControl*				mDeckControl;

	bool								mCapturing;
	BMDStreamingDeviceMode				mDeviceMode;
	BMDVideoConnection					mInputConnector;
	BMDDisplayMode						mInputMode;
	AudioStreamDecoder*					mAudioStreamDecoder;
	VTDecodeSession*					mDecodeSession;
	NSLock*								mDecodeSessionLock;
}

@property (assign) IBOutlet NSWindow* window;

- (void)haveVideoFrame:(CVPixelBufferRef)pixBuf fromNAL:(IBMDStreamingH264NALPacket*)nal;

- (void)updateUIForNewDevice;
- (void)updateUIForNoDevice;
- (void)updateEncodingPresetsUIForInputMode;

- (void)startCapture;
- (void)stopCapture;

- (IBAction)startEncodingPressed:(id)sender;
- (IBAction)videoInputModeChanged:(id)sender;

// BMDStreamingDeviceDelegate
- (void)streamingDeviceArrived:(IDeckLink*)device;
- (void)streamingDeviceRemoved:(IDeckLink*)device;
- (void)streamingDeviceModeChanged:(IDeckLink*)device toMode:(BMDStreamingDeviceMode)mode;
- (void)streamingDeviceFirmwareUpdateProgress:(IDeckLink*)device percent:(uint8_t)percent;

// BMDStreamingDeviceInputDelegate
- (void)h264NALPacketArrived:(IBMDStreamingH264NALPacket*)packet;
- (void)h264AudioPacketArrived:(IBMDStreamingAudioPacket*)packet;
- (void)mpeg2TSPacketArrived:(IBMDStreamingMPEG2TSPacket*)packet;
- (void)h264VideoInputModeChanged;

// BMDStreamingDeckControlDelegate
- (void)timecodeUpdate:(BMDTimecodeBCD)currentTimecode;
- (void)vtrControlStateChanged:(BMDDeckControlVTRControlState)newState error:(BMDDeckControlError)error;
- (void)deckControlEventReceived:(BMDDeckControlEvent)event error:(BMDDeckControlError)error;
- (void)deckControlStatusChanged:(BMDDeckControlStatusFlags)flags mask:(uint32_t)mask;

@end
